/*
 * Set the built in RTC on the Teensy 3.x using the time library. * 
 * Written by Pat Arnott, modified from TEENSY3time example.  .
 */

#include <TimeLib.h>

void setup()  {
  time_t t=now()  ; // Create a time_t variable to use.
  TimeElements tm ; // Define a TimeElements variable.
  breakTime(t,tm) ; // Initialize the time variable.
  
      tm.Second = 0        ;  // Range from 0 to 59.
      tm.Minute = 45       ;  // Range from 0 to 59.
      tm.Hour   = 1        ;  // Range from 0 to 23.
      tm.Wday   = 0        ;  // Range from 0 to 6, 0 Sunday. 
      tm.Day    = 23       ;  // Range from 1 to 31.
      tm.Month  = 4        ;  // Range from 1 to 12.
      tm.Year   = 47       ;  // Range from 0 to 99, offset from 1970, e.g. 2017=47.
       
      t=makeTime(tm)       ;  // Convert 

      Teensy3Clock.set(t) ;
      
      Serial.begin(9600)  ; 
}

void loop() {
  time_t t=Teensy3Clock.get();

  // Note: restarting the serial port reruns this program, so sets the time wrong.
  // Recommend not looking at the serial port with this program in the Teensy.
  // Recommend using the READTeensyClock, etc program.
  
  Serial.print("t=");        Serial.println(t) ;
  Serial.print("hour=");     Serial.println(hour(t)) ;
  Serial.print("minute=");   Serial.println(minute(t)) ; 
  Serial.print("second=");   Serial.println(second(t)) ; 
  Serial.print("month=");    Serial.println(month(t)) ; 
  Serial.print("day=");      Serial.println(day(t)) ; 
  Serial.print("year=");     Serial.println(year(t)) ; 

  delay(1000) ;
}

time_t getTeensy3Time()
{
  return Teensy3Clock.get();
}

