/* 
 Program to data log onto SD card the following:
 Sensirion SHT75 temperature and relative humidity measurements.
 CO2 measurement as an analog signal from the surplus sensor.
 Date and time from the Chronodot device.
 Saves data to the SD card about every 5 seconds.
*/
#include <SD.h>
#include <Sensirion.h>
#include <Wire.h>
#include <SPI.h>              // For the display and SD card.
#include <Adafruit_GFX.h>     // For the display. 
#include <Adafruit_PCD8544.h> // For the display.

// Pins used for the Sensirion SHT75 sensor.
const uint8_t dataPin  =  6; // These are the digital pins 6 and 7 on the Teensy.
const uint8_t clockPin =  7;

// Set the pins used for the Nokia 5110 LCD display.
// Software SPI (slower updates, more flexible pin options):
// pin 7 - Serial clock out (SCLK)
// pin 6 - Serial data out (DIN)
// pin 5 - Data/Command select (D/C)
// pin 4 - LCD chip select (CS)
// pin 3 - LCD reset (RST)
// Adafruit_PCD8544 display = Adafruit_PCD8544(7, 6, 5, 4, 3);
  Adafruit_PCD8544 display = Adafruit_PCD8544(5, 4, 3, 2, 1);  // Settings for the Teensy

// These are global variables, available to all functions and procedures.
int seconds;  //  00-59 
int minutes;  //  00-59 
int hours;    //  1-12 - 00-23 
int days;     //  1-7 assuming Sunday is day 1.
int date;     //  01-31
int months;   //  01-12
int years;    //  0-99 

char fname_data[] = "Sounding.txt" ;

// header is the list of things to be written at the top of all files.
// This is written every time the instrument starts so it is possible to track that.
//  String topOfFile = "Date_UTC\tTime_UTC\tT_C\tTdew_C\tRH_%\tP_mb\te_mb\trhoWV_gPerCuMet\tCO2_ppmRAW\tCO2_ppmCal\tCO_kOhms\tCO_ppm\tModComEff\tVcc_mVolts\tb_calfac\ta_calfac" ;
  String topOfFile = "Date_UTC\tTime_UTC\tT_C\tTdew_C\tRH_%\tP_mb\te_mb\trhoWV_gPerCuMet\tCO2_ppmRAW\tCO2_ppmCal\tThermistor_kOhms\tThermistor_Celcius\tVcc_mVolts" ;
  String serialnum = "ARL1 is the serial number for this card. Each sensor receives individual calibration." ; 

// Variables to be read from Sensirion sht75.
float temperature;
float humidity;
float dewpoint;
float Ro=2000.000 ; // Reference resistor value in kOhms for the thermistor measurement.

Sensirion tempSensor = Sensirion(dataPin, clockPin);

 File data;
 char filename[] = "headT.txt"; // We will write the column headings for the data in the SD card.

void setup() // every command here executes once when the Arduino turns on - good for creating files and setting up pins
{
   pinMode(10,OUTPUT); // necessary for SD shield.  This is the CS pin on the SPI port. Pins 10, 11, 12, and 13 are used on Teensy.
  if(!SD.begin(10)) // initialize SD shield
  {
    // normally here we would throw an error warning if the SD card couldn't be initialized. You can add code to light up a red LED, but otherwise you can leave this empty.
  }
  data = SD.open(filename, FILE_WRITE); // open the data file, or, if it doesn't exist, create it.
  data.println(topOfFile); // the file header
  data.println(serialnum); // serial number for this device.
  data.close();
  
  // Set up the serial port monitor to write output for computer or other monitors.
  Serial.begin(9600);
  
  // Set up the I2C connection for the chronodot2.1 clock.
  Wire.begin();
  
  // Set up the analog read characteristics.
  analogReadAveraging(1);  // Do 32 measurements and average them for every analog input measurement.
  analogReadResolution(16); // Do 16 bit analog read resolution, if available this would be great.


  // Set up the display.
  display.begin();    // init done
// you can change the contrast around to adapt the display
// for the best viewing!
  display.setContrast(50);
  display.setTextSize(1);
  display.setTextColor(BLACK);
  
}   // End void setup().

void loop()   // This is a never ending loop. //
{
   
  // Define the CO, CO2 and pressure measurements. //
  float notused;
  float temp1 ;
  float    c02;
  float    c02c;  // Calibrated CO2 = c02 * 1013.25 * (Temperature+273.15) / (Pressure * 273.15) 
  float    CO;
  float    RCO; // Resistance measured for CO sensor.
  float    sig; // Conductivity of the CO sensor, sig=1/RCO.
  float    Vcc;
  float    norm; 
  float   rhoWV ; // Water vapor density in g/m3.
  float   esTdew ; // Water vapor pressure in mb unit.
  float   b ; // temporary variable to get the water vapor part of the CO sensor calibration.
  float   a ; // calibration value for the CO sensor based on gas with known concentration calibration.
  float rhoCO ; // CO density in mg / m3 used to get the CO concentration.
  float modComEff ; // Modified combustion efficiency = deltaCO2 / (deltaCO2 + CO) and all in common ppm units.
  float   Press ; // pressure in mb computed from Press.
  float Vout ; // thermistor circuit output voltage.
  float Vin  ; // thermistor circuit input voltage.
  float RT   ; // measured thermistor resistance.
  float rat  ; // thermistor RT/Ro where Ro is the resistance at 25 C = 100 kOhm for ours.
  float aa  ; // thermistor calculation constant a from table.
  float bb  ; // thermistor calculation constant a from table.
  float cc  ; // thermistor calculation constant a from table.
  float dd  ; // thermistor calculation constant a from table.
  float Ttherm ; // thermistor temperature.

  // Analog data acquisition section.
  // Average signals over about 5 seconds to allow for proper operation of the T and RH sensor digital sensor.
  //
  // Do the c02, temperature, and RH measurements. // 
  tempSensor.measure(&temperature, &humidity, &dewpoint);
  // telaire 6004a module: 2000 ppm = 4 volts. scale factor = 2000 ppm * analogRead counts  * 3.3 volts / (4.0 volts * 65535 counts) ,
  // so the equation is CO2 in ppm = analogReadCounts / 39.72  .  The upper range will be 1650 ppm with the 3.3 volt a/d system.
  // Note:  C02 reports in ppm assuming a certain pressure and temperature.  It has to be converted to local conditions with T and P measurements.
  // We start with the normalization of the voltage.  Vcc should be 2.5 volts as a voltage divider is used.
  // Then norm = 2.5 Volts / Vcc corrects the analog voltages to expected values for the sensors.
  // CO sensor output is reported in kOhms.
  Vcc   = 0.000 ; 
  Press = 0.000 ;
  RCO   = 0.000 ;
  c02   = 0.000 ;
    for (int i=0; i <= 99; i++){ 
      notused = (float)(analogRead(3))  ;  // Premeasure Vcc.
      delay(15) ; 
      temp1   = (float)(analogRead(3))   ;
      Vcc     += temp1  ;  // Card raw voltage reported in counts.
  // Do the pressure measurement in mb.
  // Generally, Press[mb]=1111.11 Vout/Vsource + 105.6 mb, Vsource = supply voltage, Vout=pressure sensor output voltage.
  // With Teensy we use a voltage divider (50:50) to measure Vsource=2.5 Volts.
  // We also use an 18k:33k voltage divider to get the pressure signal Vout.
  // Therefore Pressure = 858.61 * AI(2)/AI(3) + 105.6 mb.  AI(2), AI(3) are the Press, Vsource counts on the A/D. 
      notused =  (float)(analogRead(2))  ;  // Premeasure of the Raw CO in a/d counts.
      delay(15) ; 
      notused =  (float)(analogRead(2))  ;  // Premeasure of the Raw CO in a/d counts.
      Press += notused/temp1 ;
//      Press +=  (float)(analogRead(2)) ;  // Raw pressure in a/d counts.
 // CO Voltage out = 5000 mVolts * 10 kOhm / (10 kOhm + Rsensor) where Rsensor is the electrochemical
 // sensor resistance.  Voltage is roughly proportional to CO, with an offset.
      notused =  (float)(analogRead(1))  ;  // Premeasure of the Raw CO in a/d counts.
      delay(10);
      RCO += (float)(analogRead(1)) * 0.050355    ;  // Vout for CO sensor in millivolts.
      notused =  (float)(analogRead(0))  ;  // Premeasure of the Raw CO in a/d counts.      
      delay(10) ;    
      c02  += (float)(analogRead(0)) / 39.72    ; 
  }

  Press = 8.58 * Press ;
//  Press=858.61*Press/Vcc   ;  // This is the slope part of the sensor calibration, assumed the same for all sensors.
//  Nominal pressure offset is 105.6 mb.  It appears to be different for each sensor.
//    Press=Press+105.6 ; // Nominal offset from the data sheet.
//    Press = Press + 110.0  ; // Specific offset for Teensy 4 card.      Updated 2/25/2016.
      Press = Press + 113.1  ; // Specific offset for Teensy 5 card.
//    Press = Press + 111.5  ; // Specific offset for Teensy 2 card.      Updated 2/25/2016.
//    Press = Press + 112.3  ; // Specific offset for Teensy 3 card.      Updated 2/25/2016.
//    Press = Press + 109.00 ; // Specific offset for Teensy 1 card.      Updated 2/25/2016.
  Vcc=0.050355*Vcc/100.0 ;  // Convert from counts in a 16 bit a/d to volts.
  Vin=2.0 * Vcc ;    // used for thermistor.
  Vout = RCO/100.0 ; // used for thermistor.
  RT = Ro * Vout / (Vin-Vout) ;  // Thermistor resistance.
  RCO = 1.0 * (2000.0 * Vcc - RCO) / RCO ; // RCO = RL * (Vcc - Vout)/Vout, RL=10kOhms.
  sig = 10000.0 / RCO ;  // Conductivity of the CO SnO2 sensor. in unusual units for simplicity.
  c02 = c02 / 100.00 ; 
  c02c = c02 * 3.7095 * (temperature + 273.15) / Press ; // Calibrated CO2 based on air density correction.
  esTdew = 6.11 * pow(10,7.5*dewpoint/(237.3 + dewpoint)) ;
  rhoWV = esTdew * 216.5 / (temperature + 273.15) ;
  // b = sig / rhoWV ;  // Calibration constant for the water vapor response of the CO sensor. Needed for each instrument.
  b = 19.4 ; // for the ARL 3 serial number sensor .
  a = 19.4 ;  // Calibration constant used to get correct CO concentration.  Needs to be determined and set for each instrument.
  CO = 2.97 * (temperature + 273.15) * (sig - b * rhoWV) / (a * Press) ;  // CO in calibrated ppm units for the given pressure and temperature.
  modComEff = (c02c - 400.0) / (c02c - 400.0 + CO)  ; // Background CO2 assumed to be 400 ppm.
// Now calculate thermistor temperature.
  rat=RT/100.0 ;
  if (rat > 3.615) {
      aa=3.350539E-3 ;
      bb=2.3721e-4   ;
      cc=3.45389e-6  ;
      dd=-5.56669e-8 ;
  }  
   else if (rat <= 3.615 && rat > 0.3266) {
      aa=3.354016E-3 ;
      bb=2.35234e-4   ;
      cc=2.89669e-6  ;
      dd=-6.37989e-8 ;
  }  
    else if (rat <= 0.3266 && rat > 0.05210) {
      aa=3.352513E-3 ;
      bb=2.32132e-4   ;
      cc=1.32555e-6  ;
      dd=-6.35511e-8 ;
  }  
    else   {
      aa=3.340135E-3 ;
      bb=2.25903e-4   ;
      cc=6.45321e-6  ;
      dd=-6.01247e-8 ;
  }  
  
  rat = log(rat) ; 
  Ttherm = aa + bb*rat + cc*rat*rat + dd*rat*rat*rat ;
  Ttherm = 1.0/Ttherm - 273.15  ; // Thermistor temperature in Celcius.
  
  // Get the actual time now, from Chronodot 2.1. // Variables are filled due to the global definitions of variable types.
  get_time();
  get_date();

 // Write the data to file. ;
  data = SD.open(fname_data, FILE_WRITE);
  digitalClockDisplaySD(); // Writes the time and date.
  data.print("\t");
  data.print(temperature);
  data.print("\t");
  data.print(dewpoint);
  data.print("\t");
  data.print(humidity);
  data.print("\t");
  data.print(Press);
  data.print("\t");
  data.print(esTdew);
  data.print("\t");
  data.print(rhoWV);
  data.print("\t"); 
  data.print(c02);
  data.print("\t");
  data.print(c02c);
  data.print("\t");
//  data.print(RCO);
  data.print(RT);  
  data.print("\t");
  data.print(Ttherm);  
  data.print("\t");  //  data.print(CO) ;
//  data.print("\t");  
//  data.print(modComEff);
//  data.print("\t");
  data.println(Vcc);
//  data.print("\t");
//  data.print(b);
//  data.print("\t");
//  data.println(a);
  data.close();

 // Write the data to the serial port too, to look at it. ;
  digitalClockDisplay(); // Writes the time and date.
  Serial.print("\t");
  Serial.print("ElapsedSeconds=" );                       
  Serial.print(millis()/1000); // basic timestamp: returns number of seconds since microcontroller was turned on - MAKE A NOTE OF THIS TIME.
  Serial.print("\tT_C=") ;
  Serial.print(temperature)  ;      
  Serial.print("\tTdew_C=") ; 
  Serial.print(dewpoint)   ;      
  Serial.print("\tRH_%=") ;
  Serial.print(humidity)  ;      
  Serial.print("\tPressure_mb=") ;
  Serial.print(Press) ;
  Serial.print("\teSatTdew_mb=") ;
  Serial.print(esTdew) ;
  Serial.print("\trhoWV_gPerCuMet=") ;
  Serial.print(rhoWV) ; 
  Serial.print("\tCO2_ppmRaw=") ;
  Serial.print(c02)  ;
  Serial.print("\tCO2_ppmCal=") ;
  Serial.print(c02c)  ;
  Serial.print("\tThermistor_Voltage=") ;
  Serial.print(Vout)  ; //  Serial.print("\tCO_kOhms=") ;
  Serial.print("\tThermistor_kOhms=") ;
//  Serial.print(RCO)  ; 
  Serial.print(RT)  ; 
    Serial.print("\tThermistor_Celcius=") ;
  Serial.print(Ttherm)  ; 
//  Serial.print("\tCO_ppm=") ;
//  Serial.print(CO)  ; 
//  Serial.print("\tModifiedComEff") ;
//  Serial.print(modComEff) ;
  Serial.print("\tVcc_mVolts=") ;
  Serial.println(Vcc)  ; 
//  Serial.print("\tb_calFac=") ;
//  Serial.print(b)  ; 
//  Serial.print("\ta_calFac=") ;
//  Serial.println(a)  ;  
  
//  delay(5000); // the SHT7x needs to wait at least 3.5 seconds between readings or it will overheat.

 // Write the data to the NOKIA 5110 screen.
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("P=") ;
      display.println(Press,3);
      display.print("T_C=") ;
      display.println(temperature,2)  ;      
      display.print("Tdew_C=") ; 
      display.println(dewpoint,2)   ;      
      display.print("RH_%=") ;
      display.println(humidity,2)  ;      
//      display.print("Th_kOhms=") ;
//      display.println(RT,1)  ; 
      display.print("Th_C=") ;
      display.println(Ttherm,2)  ;       
//      display.print("Vcc=");
//      display.println(Vcc,3) ; 
      display.display();

}  // end void loop

// SD card printing of actual time and date.
// Write the digital clock output to the SD card writer.
void digitalClockDisplaySD(){
  SDPrintDigits(months) ;
  data.print("/");
  SDPrintDigits(date) ; 
  data.print("/20") ;
  SDPrintDigits(years) ;
  data.print(" ") ;
  SDPrintDigits(hours) ;
  data.print(":") ;
  SDPrintDigits(minutes) ;
  data.print(":") ;
  SDPrintDigits(seconds) ;
  data.print("\t") ;
}
  
void SDPrintDigits(int digits){
  if(digits < 10)
    data.print("0") ; 
  data.print(digits) ;
}

void get_date()
{
  Wire.beginTransmission(104); 
  Wire.write(3);//set register to 3 (day)
  Wire.endTransmission();
  Wire.requestFrom(104, 4); //get 5 bytes(day,date,month,year,control);
  days   = bcdToDec(Wire.read());
  date  = bcdToDec(Wire.read());
  months = bcdToDec(Wire.read());
  years  = bcdToDec(Wire.read());
}

void get_time()
{
  Wire.beginTransmission(104); 
  Wire.write(0);//set register to 0
  Wire.endTransmission();
  Wire.requestFrom(104, 3);//get 3 bytes (seconds,minutes,hours);
  seconds = bcdToDec(Wire.read() & 0x7f);
  minutes = bcdToDec(Wire.read());
  hours = bcdToDec(Wire.read() & 0x3f);
}
    
///////////////////////////////////////////////////////////////////////

byte decToBcd(byte val)
{
  return ( (val/10*16) + (val%10) );
}

byte bcdToDec(byte val)
{
  return ( (val/16*10) + (val%16) );
}
//////////////////////////////////////////////////////////////////////

// Write the digital clock output to the serial port.  Can modify for the SD card writer.
void digitalClockDisplay()
{
  SerialPrintDigits(months) ;
  Serial.print("/");
  SerialPrintDigits(date) ; 
  Serial.print("/20") ;
  SerialPrintDigits(years) ;
  Serial.print(" ") ;
  SerialPrintDigits(hours) ;
  Serial.print(":") ;
  SerialPrintDigits(minutes) ;
  Serial.print(":") ;
  SerialPrintDigits(seconds) ;
}
  
void SerialPrintDigits(int digits)
{
  if(digits < 10)
    Serial.print("0") ; 
  Serial.print(digits) ;
}



    
