% Calculate height of tropopause for a series of atmospheric soundings
% taken in Reno, NV in September 2010.
format compact
clear all; close all; clc
x=[1500:1:35000];
load 'soundings.mat';

clear mex
ob=avifile('tropo.avi','fps',1,'videoname','Reno Meteorological Soundings','Compression','none');
F=figure;

for i=1:30              % 30 days in the month
    if i<10
        vn=strcat('Z00_Sep_0',num2str(i));
    else
        vn=strcat('Z00_Sep_',num2str(i));
    end
    cmd_line=strcat(['T=' vn '(:,3);']);
    eval(cmd_line);
    cmd_line=strcat(['z=' vn '(:,2);']);
    eval(cmd_line);
    
    flag=0; counter=1;
    while flag==0
        % For each sounding, the temperature-altitude relationship is
        % approximated with a polynomial interpolated from the sounding
        % data.  The polynomial interpolation is judged "accurate enough"
        % when the linear correlation between the observed and predicted
        % temperatures at a given elevation reaches as threshold value
        % (currently 0.99, but may be changed by the user).
        P=polyfit(z,T,counter);
        yp=polyval(P,z);
        C=corrcoef(yp,T);
        if C(1,2)>=0.995
            % This section is executed when the polynomial interpolation
            % reaches the defined acceptable accuracy.  The first
            % derivative of the polynomial is then taken, and the roots of
            % the derivative (indicating local minima or maxima of the
            % interpolating polynomial) are calculated.  A root falling
            % between 5,000 and 25,000 meters is then selected as the
            % height of the boundary layer.
            flag=1;
            Pp=[(length(P)-1):-1:1].*P(1:(length(P)-1));
            R=roots(Pp);
            f=find((R<20000)&(R>15000));
            H_tropo(i)=R(f);
                        
            % This section of this routine creates the avi animation of the
            % boundary layer height.
            hold off
            plot(T,z,'-b');
            hold on;
            plot(polyval(P,x),x,'--r');
            plot([-80 40],[H_tropo(i) H_tropo(i)],'-k');
            xlim([-80 40]); ylim([1500 35000]);
            xlabel('Temperature (^oC)');
            ylabel('Elevation (m AMSL)');
            set(gca,'ytick',[0 5000 10000 15000 20000 25000 30000 35000]);
            set(gca,'yticklabel',{'0','5,000','10,000','15,000','20,000','25,000','30,000','35,000'});
            title(strcat(['Reno Sounding: 1700L, Sept. ' num2str(i) ', 2010']));
            legend('Atmospheric Sounding','Polynomial Approximation','Tropopause Height','location','northeast')
            G=getframe(F);
            ob=addframe(ob,G);            
        end
        counter=counter+1;
        if counter>9
            flag=1;
            H_tropo(i)=NaN;
        end
    end
    clear T z flag P yp C P Pp R cmd_line counter f vn G;
end

close(F);
ob=close(ob);
clear x F ob i;
save 'soundings.mat'