% Calculate height of temperature inversion for a series of atmospheric
% soundings taken in Reno, NV in September 2010.
clear all;close all;
load 'soundings.mat';
load 'soundings_posted.mat'
format compact;

clear mex;
ob=avifile('inversion.avi','fps',1,'videoname','Reno Meteorological Soundings','Compression','none');
F=figure;

for i=1:30              % 30 days in the month
    % Create the vectors T and z for the appropriate day
    if i<10
        vn=strcat('Z12_Sep_0',num2str(i));
    else
        vn=strcat('Z12_Sep_',num2str(i));
    end
    cmd_line=strcat(['T=' vn '(:,3);']);
    eval(cmd_line);
    cmd_line=strcat(['z=' vn '(:,2);']);
    eval(cmd_line);
    
    flag=0; n=2;
    while flag==0
        % For each sounding, the temperature-altitude relationship between
        % the surface and the height of the nth measurement is approximated
        % with a linear function.  
        Tn=T(1:n); zn=z(1:n);
        if issorted(Tn)     % This statement finds the first value of T
                            % that is out of order
            n=n+1;
            continue;
        end
        if T(n+1)>T(n-1)
            n=n+1;
            continue;
        end
        H_inversion(i)=z(n-1)-1516;
        if H_inversion(i)>0
            clear q;
            q=polyfit(z(1:n-1),T(1:n-1),1);
            Lapse(i)=1000*q(1);
            %Lapse(i)=1000*(max(T(1:n))-min(T(1:n)))/(max(z(1:n))-min(z(1:n)));
        else
            Lapse(i)=0;
        end
        flag=1;
        
        % This section creates the plots for the animation
        hold off
        plot(T(1:60),z(1:60)-1516,'-b');
        hold on;
        plot([-20 30],[H_inversion(i) H_inversion(i)],'-k');
        xlim([-20 30]); ylim([0 5000]);
        xlabel('Temperature (^oC)');
        ylabel('Elevation (m above ground)');
        title(strcat(['Reno Sounding: 1700L, Sept. ' num2str(i) ', 2010']));
        legend('Atmospheric Sounding','Inversion Height','location','northwest')
        
        % Capture plot and add to animation file
        G=getframe(F);
        ob=addframe(ob,G);            
    end
    clear T z flag P yp C P Pp R cmd_line counter f vn G Tn zn n q;
end

close(F);
ob=close(ob);
clear x F ob i;

save 'soundings.mat';

figure;
scatter(Lapse,Lapse_posted);
xlim([0 80]);ylim([0 80]);
hold on
plot([0 80],[0 80],'-k');
xlabel('MATLAB-calculated Lapse Rate (K/km)');
ylabel('Previously Calculated Lapse Rate (K/km)');
title('0500L Lapse Rates in Reno, NV: September, 2010')

figure;
scatter(H_inversion,WPA_inversion);
hold on;plot([0 500],[0 500],'-k')
xlabel('MATLAB Calculated Inversion Height (m)')
ylabel('Posted Inversion Height (m)')
title('Inversion Heights: 0500L, September 2010');

figure;
plot(1:30,H_inversion,'-b',1:30,WPA_inversion,'-.r');
xlabel('Day of Month');
ylabel('Height of Inversion (m)');
title('0500L Temperature Inversion in Reno, NV: Septemmber 2010');
legend('MATLAB Calculated','Posted Solution','location','northwest');