clear all;close all;clc;

% Opens the text file 'sounding.txt' for reading.
fid=fopen('sounding.txt','r');

% Initialize a few variables used for navigating the file
flag=0;
start=0; finish=0;

while flag==0
    C=fgetl(fid);   % Read one line from the file
    if C==-1        % If we've reached the end of the file, break the while loop here
        flag=1;
        continue;
    end
    if strfind(C,'Z')==38       % Indicates the beginning of a new sounding
        vname=strcat(C(38),C(36:37),'_',C(43:45),'_',C(40:41)); % create a string for the variable name for this particular sounding
        for i=1:5
            fgetl(fid); % Skip through 5 lines of header info
        end
        start=ftell(fid);   % Save the location (byte number) of the
                            % beginning of the day's data
        count=0;            % count will keep track of the number of lines
                            % for the day's data table
        varflag=0;
        while varflag==0
            C=fgetl(fid);
            if ~isempty(C)  % This if statement skips through the first two
                            % or three lines where pressure is less than
                            % the surface pressure in Reno
                if C(17:21)=='     '
                    start=ftell(fid);   % Starting point for actual data table
                    continue
                end
            end
            count=count+1;
            if isempty(C)   % Looks for marker indicating the end of the 
                            % day's data table
                finish=ftell(fid);  % Location of the end of the data table
                varflag=1;
            end
        end
        fseek(fid,start,'bof'); % Goes back to beginning of data table
        
        % The next statement reads the full day's data set into a single
        % variable data_mat
        data_mat=transpose(fscanf(fid,'%f',[11,count]));
        
        % This sequence provides some error trapping to ake up for the fact
        % that the command fscanf doesn't handle blanks in the data very
        % well.
        if ~issorted(1000-data_mat(:,1))
            e_flag=0;
            j=1;
            while e_flag==0
                q=data_mat(1:length(data_mat(:,1))-j,:);
                if issorted(1000-q(:,1))
                    clear data_mat; data_mat=q(1:(length(q)-1),:);
                    e_flag=1;
                end
                j=j+1;
            end
        else
            q=data_mat(1:length(data_mat(:,1))-1,:);
            clear data_mat; data_mat=q(1:(length(q)-1),:);
        end
        % end of error trapping sequence
        
        % assigns the data to a variable named to indicate the date and
        % time of the sounding
        vline=strcat(vname,'=data_mat;');
        eval(vline);
        
        % clear variables that will be used again in the next iteration of
        % the loop
        clear vline vname C i varflag count data_mat;
    end
end

% Close the original text file
fid=fclose(fid);

% clear any variables other than the sounding data
clear fid flag ans finish start C e_flag j q;

% save the parsed data as a new MATLAB data file.
save 'soundings.mat'