% Calculate height of boundary layer for a series of atmospheric soundings
% taken in Reno, NV in September 2010.
format compact
clear all;close all;clc;
load 'soundings.mat';
load 'soundings_posted.mat';


clear mex;
ob=avifile('boundary.avi','fps',1,'videoname','Reno Meteorological Soundings');
F=figure;
threshold=-122;

for i=1:30    % One iteration per day of the record
    % Create vectors for temperature and elevation. This section of the 
    % code creates vectors z and T from the sounding for the ith day of
    % September.
    if i<10
        vn=strcat('Z00_Sep_0',num2str(i));
    else
        vn=strcat('Z00_Sep_',num2str(i));
    end
    cmd_line=strcat(['T=' vn '(:,3);']);
    eval(cmd_line);
    cmd_line=strcat(['z=' vn '(:,2);']);
    eval(cmd_line);
    
    % creat vectors showing the incremental changes in temperature and 
    % distance in vectors T and z.
    a=length(z);
    dz=z(2:a)-z(1:a-1);
    dT=T(2:a)-T(1:a-1);
    dzdT=dz./dT;
    
    % Calculate height of the boundary layer
    flag=0; j=4;
    while flag==0
        j=j+1;  % The counter j is used to keep track of how high in the 
                % atmosphere we're going.
        if dzdT(j)<threshold    % If z(T) is changing faster than the 
                                % threshold (as defined in line 10)
            q=polyfit(T(j-4:j+4),z(j-4:j+4),1); % Determine a linear 
                                                % regression for the nine
                                                % points centered on j
            if q(1)>threshold   % If the slope of that regression is less
                                % than threshold, do nothing and skip to
                                % the next j
                continue;
            end
            q=polyfit(T(j:j+3),z(j:j+3),1); % Deterine a linear regression
                                            % using the 4 points beginning
                                            % with j and moving up
            if q(1)<threshold   % If the slope of that regression is greater
                                % than the threshold, then the boundary
                                % layer ends at the point j
                flag=1;         % Changing flag to 1 indicates that the
                                % while loop will be ended.
                continue
            end
        end
        if j>a-3                % Error trapping to prevent overrunning the
                                % vectors z and T
            flag=1;
        end
    end
    H_boundary(i)=(z(j+1)+z(j))/2-z(1);     % This statement records the
                                            % height of the boundary layer
                                            % as the elvation of record j
    
	% This section of the code creates the plots and records the sequence
	% in the avi file opened above.
    hold off
    plot(T,z-1516,'-b');
    hold on;
    plot([-50 30],[H_boundary(i) H_boundary(i)],'-k');
    xlim([-50 30]); ylim([0 10000]);
    xlabel('Temperature (^oC)');
    ylabel('Elevation (m above ground)');
    title(strcat(['Reno Sounding: 1700L, Sept. ' num2str(i) ', 2010']));
    legend('Atmospheric Sounding','Boundary Layer Height','location','northeast')
    
    % Plot recording 
    G=getframe(F);
    ob=addframe(ob,G);
    
    % Clear variables for next iteration - this is necessary when working
    % with vectors or arrays that may be different sizes in subsequent
    % iterations
    clear cmd_line vn T z j flag dz dT dzdT a q 
end

close(F);       % Closes the figure that is being animated
ob=close(ob);   % Closes the animation file
clear i ob F G threshold;

% Create a scatterplot to compare the boundary layer height calculated by
% this code to the boundary layer height from the spreadsheet posted on the
% class website (contained in the vector WPA_boundary)
figure;
scatter(H_boundary,WPA_boundary);
hold on; plot([0 5500],[0 5500],'-k');
xlim([500 5500]);ylim([500 5500]);
xlabel('MATLAB Estimate (m)');
ylabel('Posted Height (m)');
title('Boundary Layer Height: September, 2010');
R=corrcoef(H_boundary,WPA_boundary)     % Quick measure of the quality of
                                        % the estimates from this code
save 'soundings.mat';   % save the file with the addition of the boundary
                        % layer height and the correlation value

% This section creates the plot of boundary layer height as calculated here
% and as posted on the class website.
figure('visible','off');
plot(1:30,WPA_boundary,1:30,H_boundary);
xlabel('Day of Month');
ylabel('Boundary Layer Height (m)');
title('Boundary Layer Height: September, 2010');
ylim([0 5500]);
legend('Posted Solution','MATLAB Solution','location','northwest');
set(gcf,'visible','on');