/* Example program to measure the response time of the Cadmium Sulfide (CS) photocell.
Written by: Pat Arnott, April 2016, for ATMS 360.
The photocell resistance is measured indirectly with a voltage divider.
+5v ------/\/\/\------/\/\/\------- gnd
         500 Ohms      CS
                  Vout
Vout is measured between the fixed resistor and photocell.
Pulsed LED illumination is used to test the cell.
The three color LED can be used to test the response to red, green, and blue light.
Bend the LED and photocell to face each other.
 */
 
// Global variable definitions. 
// Note these are the pins to connect on the Arduino.
int ledPin = 13;
int sensorPin = A0;    // Analog input pin for the photocell voltage.
int sensorValue = 0;   // Variable to store the measurement from the sensor.
int i ;  // variable in for loop.

// We put out setup code here, to run only once at the start:
void setup() {
  pinMode(ledPin, OUTPUT);
  Serial.begin(230400) ;  // Sets the serial port to 230400 bits per second transfer.
}

// We put our main code here, to run repeatedly:
void loop() {
   digitalWrite(ledPin, LOW);  // This turns the LED off.
   delay(5000) ; // wait 5 seconds to give some time between measurements.
   
// First do 100 measurements of the optical sensor with the LED off.
  for (i=0 ; i < 100; i++) {
    sensorValue = analogRead(sensorPin);
    Serial.print(micros()) ; Serial.print(",") ;
    Serial.println(sensorValue) ;
  }
  
// Next do 200 measurements of the optical sensor with the LED on.
  digitalWrite(ledPin, HIGH);   // This turns the LED on.
  for (i=0 ; i < 200; i++) {
    sensorValue = analogRead(sensorPin);
    Serial.print(micros()) ; Serial.print(",") ;
    Serial.println(sensorValue) ;
  }

// Next do 100 measurements of the optical sensor with the LED off.
  digitalWrite(ledPin, LOW);   // This turns the LED on.
  for (i=0 ; i < 100; i++) {
    sensorValue = analogRead(sensorPin);
    Serial.print(micros()) ; Serial.print(",") ;
    Serial.println(sensorValue) ;
  }
 
  }
